/*
 * Decompiled with CFR 0.152.
 */
package net.hibiscus.naturespirit.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.hibiscus.naturespirit.NatureSpirit;
import net.hibiscus.naturespirit.registration.NSBiomes;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;

public class TerraSolarisParameters
extends class_6554 {
    private final class_6544.class_6546 defaultParameter = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    private final class_6544.class_6546[] temperatureParameters = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f), class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f), class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f), class_6544.class_6546.method_38121((float)0.2f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    private final class_6544.class_6546[] humidityParameters = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f), class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f), class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f), class_6544.class_6546.method_38121((float)0.1f, (float)0.3f), class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)};
    private final class_6544.class_6546[] erosionParameters = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f), class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f), class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f), class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f), class_6544.class_6546.method_38121((float)0.05f, (float)0.45f), class_6544.class_6546.method_38121((float)0.45f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    private final class_6544.class_6546 frozenTemperature;
    private final class_6544.class_6546 nonFrozenTemperatureParameters;
    private final class_6544.class_6546 mushroomFieldsContinentalness;
    private final class_6544.class_6546 deepOceanContinentalness;
    private final class_6544.class_6546 oceanContinentalness;
    private final class_6544.class_6546 coastContinentalness;
    private final class_6544.class_6546 riverContinentalness;
    private final class_6544.class_6546 nearInlandContinentalness;
    private final class_6544.class_6546 midInlandContinentalness;
    private final class_6544.class_6546 farInlandContinentalness;
    private final class_5321<class_1959>[][] oceanBiomes;
    private final class_5321<class_1959>[][] commonBiomes;
    private final class_5321<class_1959>[][] uncommonBiomes;
    private final class_5321<class_1959>[][] nearMountainBiomes;
    private final class_5321<class_1959>[][] specialNearMountainBiomes;
    private final class_5321<class_1959>[][] windsweptBiomes;
    class_5321<class_1959> commonBiomeForestCold;
    class_5321<class_1959> nearBiomeForestCold;
    class_5321<class_1959> commonBiomeTaigaCold;
    class_5321<class_1959> commonBiomeOldSpruceCold;
    class_5321<class_1959> uncommonBiomeOldPineCold;
    class_5321<class_1959> commonPlains;
    class_5321<class_1959> commonForest;
    class_5321<class_1959> uncommonNull;
    class_5321<class_1959> specialForest;
    class_5321<class_1959> commonBirchForest;
    class_5321<class_1959> uncommonBirchForest;
    class_5321<class_1959> mountainMeadow;
    class_5321<class_1959> windsweptHills;
    class_5321<class_1959> windsweptHills2;
    class_5321<class_1959> windsweptForest;
    class_5321<class_1959> plainsCold;
    class_5321<class_1959> meadowCold;
    class_5321<class_1959> nullCold;
    class_5321<class_1959> cherryCold;
    class_5321<class_1959> windsweptGravelyHillsCold;
    class_5321<class_1959> windsweptHillsCold;
    class_5321<class_1959> windsweptForestCold;

    public TerraSolarisParameters() {
        this.commonBiomeForestCold = NatureSpirit.CONFIG.has_woody_highlands ? NSBiomes.WOODY_HIGHLANDS : class_1972.field_9409;
        this.nearBiomeForestCold = NatureSpirit.CONFIG.has_blooming_highlands ? NSBiomes.BLOOMING_HIGHLANDS : class_1972.field_9409;
        this.commonBiomeTaigaCold = NatureSpirit.CONFIG.has_woody_highlands ? NSBiomes.WOODY_HIGHLANDS : class_1972.field_9420;
        this.commonBiomeOldSpruceCold = NatureSpirit.CONFIG.has_woody_highlands ? NSBiomes.WOODY_HIGHLANDS : class_1972.field_35113;
        this.uncommonBiomeOldPineCold = NatureSpirit.CONFIG.has_woody_highlands ? null : class_1972.field_35119;
        this.commonPlains = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_9451;
        this.commonForest = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_9409;
        this.uncommonNull = NatureSpirit.CONFIG.has_blooming_sugi_forest ? NSBiomes.BLOOMING_SUGI_FOREST : null;
        this.specialForest = NatureSpirit.CONFIG.has_blooming_sugi_forest ? NSBiomes.BLOOMING_SUGI_FOREST : class_1972.field_9409;
        this.commonBirchForest = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_9412;
        this.uncommonBirchForest = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_35112;
        this.mountainMeadow = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_34470;
        this.windsweptHills = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_35116;
        this.windsweptHills2 = NatureSpirit.CONFIG.has_floral_ridges ? NSBiomes.FLORAL_RIDGES : class_1972.field_35116;
        this.windsweptForest = NatureSpirit.CONFIG.has_sugi_forest ? NSBiomes.SUGI_FOREST : class_1972.field_35120;
        this.plainsCold = NatureSpirit.CONFIG.has_shrubby_highlands ? NSBiomes.SHRUBBY_HIGHLANDS : class_1972.field_9451;
        this.meadowCold = NatureSpirit.CONFIG.has_blooming_highlands ? NSBiomes.BLOOMING_HIGHLANDS : class_1972.field_34470;
        this.nullCold = NatureSpirit.CONFIG.has_arid_highlands ? NSBiomes.ARID_HIGHLANDS : null;
        this.cherryCold = NatureSpirit.CONFIG.has_arid_highlands ? NSBiomes.ARID_HIGHLANDS : class_1972.field_42720;
        this.windsweptGravelyHillsCold = NatureSpirit.CONFIG.has_arid_highlands ? NSBiomes.ARID_HIGHLANDS : class_1972.field_35111;
        this.windsweptHillsCold = NatureSpirit.CONFIG.has_shrubby_highlands ? NSBiomes.SHRUBBY_HIGHLANDS : class_1972.field_35116;
        this.windsweptForestCold = NatureSpirit.CONFIG.has_shrubby_highlands ? NSBiomes.SHRUBBY_HIGHLANDS : class_1972.field_35120;
        this.frozenTemperature = this.temperatureParameters[0];
        this.nonFrozenTemperatureParameters = class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatureParameters[1], (class_6544.class_6546)this.temperatureParameters[4]);
        this.mushroomFieldsContinentalness = class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f);
        this.deepOceanContinentalness = class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f);
        this.oceanContinentalness = class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f);
        this.coastContinentalness = class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f);
        this.riverContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f);
        this.nearInlandContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f);
        this.midInlandContinentalness = class_6544.class_6546.method_38121((float)0.03f, (float)0.3f);
        this.farInlandContinentalness = class_6544.class_6546.method_38121((float)0.3f, (float)1.0f);
        this.oceanBiomes = new class_5321[][]{{class_1972.field_9418, class_1972.field_9470, class_1972.field_9446, class_1972.field_9439, class_1972.field_9408}, {class_1972.field_9435, class_1972.field_9467, class_1972.field_9423, class_1972.field_9441, class_1972.field_9408}};
        this.commonBiomes = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9420}, {this.plainsCold, this.plainsCold, this.commonBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {class_1972.field_9414, this.commonPlains, this.commonForest, this.commonBirchForest, class_1972.field_9475}, {class_1972.field_9449, class_1972.field_9449, class_1972.field_9409, class_1972.field_9417, class_1972.field_9417}, {class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424}};
        this.uncommonBiomes = new class_5321[][]{{class_1972.field_9453, null, class_1972.field_9454, null, null}, {null, null, null, null, this.uncommonBiomeOldPineCold}, {class_1972.field_9455, this.uncommonNull, this.uncommonNull, this.uncommonBirchForest, null}, {null, null, class_1972.field_9451, class_1972.field_35118, class_1972.field_9440}, {null, null, null, null, null}};
        this.nearMountainBiomes = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9454}, {this.meadowCold, this.meadowCold, this.nearBiomeForestCold, this.commonBiomeTaigaCold, this.commonBiomeOldSpruceCold}, {class_1972.field_34470, class_1972.field_34470, this.mountainMeadow, this.mountainMeadow, class_1972.field_9475}, {class_1972.field_9430, class_1972.field_9430, class_1972.field_9409, class_1972.field_9409, class_1972.field_9417}, {class_1972.field_9415, class_1972.field_9415, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}};
        this.specialNearMountainBiomes = new class_5321[][]{{class_1972.field_9453, null, null, null, null}, {this.cherryCold, this.nullCold, this.meadowCold, this.meadowCold, this.uncommonBiomeOldPineCold}, {class_1972.field_42720, class_1972.field_42720, this.specialForest, this.commonBirchForest, null}, {null, null, null, null, null}, {class_1972.field_9443, class_1972.field_9443, null, null, null}};
        this.windsweptBiomes = new class_5321[][]{{class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {this.windsweptGravelyHillsCold, this.windsweptGravelyHillsCold, this.windsweptHillsCold, this.windsweptForestCold, this.windsweptForestCold}, {this.windsweptHills2, this.windsweptHills2, this.windsweptHills, this.windsweptForest, this.windsweptForest}, {null, null, null, null, null}, {null, null, null, null, null}};
    }

    protected void method_38185(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.writeOceanBiomes(parameters);
        this.writeLandBiomes(parameters);
        this.method_38199(parameters);
    }

    private void writeOceanBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.writeBiomeParameters(parameters, this.defaultParameter, this.defaultParameter, this.mushroomFieldsContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, (class_5321<class_1959>)class_1972.field_9462);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            this.writeBiomeParameters(parameters, parameterRange, this.defaultParameter, this.deepOceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[0][i]);
            this.writeBiomeParameters(parameters, parameterRange, this.defaultParameter, this.oceanContinentalness, this.defaultParameter, this.defaultParameter, 0.0f, this.oceanBiomes[1][i]);
        }
    }

    private void writeLandBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.93333334f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)-0.93333334f, (float)-0.7666667f));
        this.writePeakBiomes(parameters, class_6544.class_6546.method_38121((float)-0.7666667f, (float)-0.56666666f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)-0.56666666f, (float)-0.4f));
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)-0.4f, (float)-0.26666668f));
        this.writeLowBiomes(parameters, class_6544.class_6546.method_38121((float)-0.26666668f, (float)-0.05f));
        this.writeValleyBiomes(parameters, class_6544.class_6546.method_38121((float)-0.05f, (float)0.05f));
        this.writeLowBiomes(parameters, class_6544.class_6546.method_38121((float)0.05f, (float)0.26666668f));
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)0.26666668f, (float)0.4f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)0.4f, (float)0.56666666f));
        this.writePeakBiomes(parameters, class_6544.class_6546.method_38121((float)0.56666666f, (float)0.7666667f));
        this.writeHighBiomes(parameters, class_6544.class_6546.method_38121((float)0.7666667f, (float)0.93333334f));
        this.writeMidBiomes(parameters, class_6544.class_6546.method_38121((float)0.93333334f, (float)1.0f));
    }

    private void writePeakBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getBadlandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getNearMountainBiome(i, j, weirdness);
                class_5321<class_1959> registryKey5 = this.getWindsweptOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey6 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey5);
                class_5321<class_1959> registryKey7 = this.getPeakBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeHighBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getBadlandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getNearMountainBiome(i, j, weirdness);
                class_5321<class_1959> registryKey5 = this.getWindsweptOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey6 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey);
                class_5321<class_1959> registryKey7 = this.getMountainSlopeBiome(i, j, weirdness);
                class_5321<class_1959> registryKey8 = this.getPeakBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[0], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey8);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey7);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[2], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[3], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeMidBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[2]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9419);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getBadlandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getWindsweptOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey5 = this.getNearMountainBiome(i, j, weirdness);
                class_5321<class_1959> registryKey6 = this.getShoreBiome(i, j);
                class_5321<class_1959> registryKey7 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey);
                class_5321<class_1959> registryKey8 = this.getErodedShoreBiome(i, j, weirdness);
                class_5321<class_1959> registryKey9 = this.getMountainSlopeBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[0], weirdness, 0.0f, registryKey9);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.midInlandContinentalness), this.erosionParameters[1], weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[1], weirdness, 0.0f, i == 0 ? registryKey9 : registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.midInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.farInlandContinentalness, this.erosionParameters[2], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[3], weirdness, 0.0f, registryKey2);
                if (weirdness.comp_104() < 0L) {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[4], weirdness, 0.0f, registryKey6);
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                } else {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                }
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey8);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey7);
                if (weirdness.comp_104() < 0L) {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey6);
                    continue;
                }
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey);
            }
        }
    }

    private void writeLowBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(parameters, this.defaultParameter, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[2]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9419);
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey2 = this.getBadlandsOrRegularBiome(i, j, weirdness);
                class_5321<class_1959> registryKey3 = this.getMountainStartBiome(i, j, weirdness);
                class_5321<class_1959> registryKey4 = this.getShoreBiome(i, j);
                class_5321<class_1959> registryKey5 = this.getBiomeOrWindsweptSavanna(i, j, weirdness, registryKey);
                class_5321<class_1959> registryKey6 = this.getErodedShoreBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType(i, j, weirdness));
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey3);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[3]), weirdness, 0.0f, registryKey2);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[3], (class_6544.class_6546)this.erosionParameters[4]), weirdness, 0.0f, registryKey4);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[4], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[5], weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey6);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, this.erosionParameters[5], weirdness, 0.0f, registryKey5);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, registryKey4);
            }
        }
    }

    private void writeValleyBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)(weirdness.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9463));
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[5]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, this.coastContinentalness, this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        this.writeBiomeParameters(parameters, this.frozenTemperature, this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.riverContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9463);
        if (!NatureSpirit.CONFIG.has_sugi_forest) {
            this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)(weirdness.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9438));
            this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
            this.writeBiomeParameters(parameters, this.nonFrozenTemperatureParameters, this.defaultParameter, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[4]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
        }
        for (int i = 0; i < this.temperatureParameters.length; ++i) {
            class_6544.class_6546 parameterRange = this.temperatureParameters[i];
            for (int j = 0; j < this.humidityParameters.length; ++j) {
                class_6544.class_6546 parameterRange2 = this.humidityParameters[j];
                class_5321<class_1959> registryKey = this.getBadlandsOrRegularBiome(i, j, weirdness);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, registryKey);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosionParameters[6], weirdness, 0.0f, this.getWetlandType2(i, j, weirdness));
                if (!NatureSpirit.CONFIG.has_sugi_forest) continue;
                if (i == 2 && j < 4 && j > 0) {
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, NSBiomes.SUGI_FOREST);
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, NSBiomes.SUGI_FOREST);
                    this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[4]), weirdness, 0.0f, NSBiomes.SUGI_FOREST);
                    continue;
                }
                if (i <= 0) continue;
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)(weirdness.comp_104() < 0L ? class_1972.field_9419 : class_1972.field_9438));
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[0], (class_6544.class_6546)this.erosionParameters[1]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
                this.writeBiomeParameters(parameters, parameterRange, parameterRange2, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosionParameters[2], (class_6544.class_6546)this.erosionParameters[4]), weirdness, 0.0f, (class_5321<class_1959>)class_1972.field_9438);
            }
        }
    }

    private class_5321<class_1959> getRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            return this.commonBiomes[temperature][humidity];
        }
        class_5321<class_1959> registryKey = this.uncommonBiomes[temperature][humidity];
        return registryKey == null ? this.commonBiomes[temperature][humidity] : registryKey;
    }

    private class_5321<class_1959> getWetlandType(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature == 0) {
            return this.getRegularBiome(temperature, humidity, weirdness);
        }
        if (temperature >= 2 && temperature <= 3 && humidity < 3 && NatureSpirit.CONFIG.has_wisteria_forest) {
            return NSBiomes.WISTERIA_FOREST;
        }
        if (temperature == 3 && humidity > 2 && NatureSpirit.CONFIG.has_bamboo_wetlands) {
            return NSBiomes.BAMBOO_WETLANDS;
        }
        if ((humidity <= 3 || temperature == 4) && NatureSpirit.CONFIG.has_marsh) {
            return NSBiomes.MARSH;
        }
        return class_1972.field_9471;
    }

    private class_5321<class_1959> getWetlandType2(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature == 0) {
            return this.getRegularBiome(temperature, humidity, weirdness);
        }
        if (temperature == 3 && humidity < 3 && NatureSpirit.CONFIG.has_wisteria_forest) {
            return NSBiomes.WISTERIA_FOREST;
        }
        if (temperature == 2 && NatureSpirit.CONFIG.has_sugi_forest) {
            return NSBiomes.SUGI_FOREST;
        }
        if (temperature == 3 && humidity > 2 && NatureSpirit.CONFIG.has_bamboo_wetlands) {
            return NSBiomes.BAMBOO_WETLANDS;
        }
        if ((humidity <= 3 || temperature == 4) && NatureSpirit.CONFIG.has_marsh) {
            return NSBiomes.MARSH;
        }
        return class_1972.field_9471;
    }

    private class_5321<class_1959> getBadlandsOrRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        return temperature == 4 ? this.getBadlandsBiome(humidity, weirdness) : (temperature == 1 ? this.getSteppeBiome(temperature, humidity, weirdness) : this.getRegularBiome(temperature, humidity, weirdness));
    }

    private class_5321<class_1959> getMountainStartBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        return temperature == 0 ? this.getMountainSlopeBiome(temperature, humidity, weirdness) : this.getBadlandsOrRegularBiome(temperature, humidity, weirdness);
    }

    private class_5321<class_1959> getBiomeOrWindsweptSavanna(int temperature, int humidity, class_6544.class_6546 weirdness, class_5321<class_1959> biomeKey) {
        if (temperature == 2 && humidity < 4 && NatureSpirit.CONFIG.has_sugi_forest) {
            return weirdness.comp_104() >= 0L ? NSBiomes.WINDSWEPT_SUGI_FOREST : biomeKey;
        }
        if (temperature == 3 && humidity < 4 && NatureSpirit.CONFIG.has_floral_ridges) {
            return weirdness.comp_104() >= 0L ? NSBiomes.FLORAL_RIDGES : biomeKey;
        }
        return temperature > 1 && humidity < 4 && weirdness.comp_104() >= 0L ? class_1972.field_35114 : biomeKey;
    }

    private class_5321<class_1959> getErodedShoreBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> registryKey = weirdness.comp_104() >= 0L ? this.getRegularBiome(temperature, humidity, weirdness) : this.getShoreBiome(temperature, humidity);
        return this.getBiomeOrWindsweptSavanna(temperature, humidity, weirdness, registryKey);
    }

    private class_5321<class_1959> getShoreBiome(int temperature, int humidity) {
        if (temperature == 0) {
            return class_1972.field_9478;
        }
        if (temperature == 3 && NatureSpirit.CONFIG.has_tropical_shores) {
            return NSBiomes.TROPICAL_SHORES;
        }
        return temperature == 4 ? class_1972.field_9424 : class_1972.field_9434;
    }

    private class_5321<class_1959> getBadlandsBiome(int humidity, class_6544.class_6546 weirdness) {
        if (humidity < 2) {
            return weirdness.comp_104() < 0L ? class_1972.field_9415 : class_1972.field_9443;
        }
        return humidity < 3 ? class_1972.field_9415 : class_1972.field_35110;
    }

    private class_5321<class_1959> getSteppeBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (humidity < 3 && NatureSpirit.CONFIG.has_arid_highlands) {
            return NSBiomes.ARID_HIGHLANDS;
        }
        return humidity < 4 && NatureSpirit.CONFIG.has_shrubby_highlands ? NSBiomes.SHRUBBY_HIGHLANDS : (NatureSpirit.CONFIG.has_woody_highlands ? NSBiomes.WOODY_HIGHLANDS : this.getRegularBiome(temperature, humidity, weirdness));
    }

    private class_5321<class_1959> getNearMountainBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> registryKey;
        if (weirdness.comp_104() >= 0L && (registryKey = this.specialNearMountainBiomes[temperature][humidity]) != null) {
            return registryKey;
        }
        return this.nearMountainBiomes[temperature][humidity];
    }

    private class_5321<class_1959> getPeakBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature == 1 && NatureSpirit.CONFIG.has_snowcapped_red_peaks) {
            return NSBiomes.SNOWCAPPED_RED_PEAKS;
        }
        if (temperature <= 2) {
            return weirdness.comp_104() < 0L ? class_1972.field_34474 : class_1972.field_35115;
        }
        return temperature == 3 ? class_1972.field_34475 : this.getBadlandsBiome(humidity, weirdness);
    }

    private class_5321<class_1959> getMountainSlopeBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        if (temperature >= 3) {
            return this.getNearMountainBiome(temperature, humidity, weirdness);
        }
        if (temperature == 1 && NatureSpirit.CONFIG.has_sleeted_slopes) {
            return NSBiomes.SLEETED_SLOPES;
        }
        return humidity <= 1 ? class_1972.field_34472 : class_1972.field_34471;
    }

    private class_5321<class_1959> getWindsweptOrRegularBiome(int temperature, int humidity, class_6544.class_6546 weirdness) {
        class_5321<class_1959> registryKey = this.windsweptBiomes[temperature][humidity];
        return registryKey == null ? this.getRegularBiome(temperature, humidity, weirdness) : registryKey;
    }

    private void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }
}

